/********************************************************************************************************
Replication data and analyses for:
Johnson, Jaclyn, and Clayton L. Thyne. 2018. “Squeaky Wheels and Troop Loyalty: 
How Domestic Protests Influence Coups d’état, 1952-2005.” Journal of Conflict Resolution, 62(3):597-625.
********************************************************************************************************/

/*Table 1*/		use "johnson_thyne_JCR_2018_base.dta", clear
	/*Model 1*/ 	logit coup protests gdppc dem auth milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, robust nolog cluster(ccode)
	/*Model 2*/ 	logit coup protests_near protests_far gdppc dem auth milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, robust nolog cluster(ccode)
	/*Model 3*/ 	logit coup protests_violent protests_peaceful gdppc dem auth milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, robust nolog cluster(ccode)

/*Table 2*/		use "johnson_thyne_JCR_2018_base.dta", clear
	/*Model 1*/		xi: clogit coup protests gdppc dem auth milreg cwongo coupmonths coupmonths2 coupmonths3, group(ccode) nolog
	/*Model 2*/		xi: clogit coup protests_near protests_far gdppc dem auth milreg cwongo coupmonths coupmonths2 coupmonths3, group(ccode) nolog
	/*Model 3*/		xi: clogit coup protests_violent protests_peaceful gdppc dem auth gdppc milreg cwongo coupmonths coupmonths2 coupmonths3, group(ccode) nolog
	/*Model 4*/		xi: clogit coup protests gdppc dem auth milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, group(year) nolog
	/*Model 5*/		xi: clogit coup protests_near protests_far gdppc dem auth milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, group(year) nolog
	/*Model 6*/		xi: clogit coup protests_violent protests_peaceful gdppc dem auth milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, group(year) nolog
	use "johnson_thyne_JCR_2018_cem.dta", clear
	/*Model 7*/ 	logit coup protests_dummy gdppc dem auth milreg cwongo coupmonths coupmonths2 coupmonths3 [iweight=cem_weights], nolog
	/*Model 8*/		logit coup protests_near protests_far dem auth gdppc milreg cwongo coupmonths coupmonths2 coupmonths3 [iweight=cem_weights], nolog
	/*Model 9*/		logit coup protests_violent protests_peaceful dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3 [iweight=cem_weights], nolog
	use "johnson_thyne_JCR_2018_dev.dta", clear
	/*Model 10*/	logit coup protests_mean protests_dev dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, nolog cluster(ccode)	
	/*Model 11*/	logit coup protests_near_mean protests_near_dev protests_far_mean protests_far_dev dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, nolog cluster(ccode)	
	/*Model 12*/	logit coup protests_violent_mean protests_violent_dev protests_peaceful_mean protests_peaceful_dev dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, nolog cluster(ccode)	
	/*Model 13*/	logit coup coup_mean protests_mean protests_dev dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, nolog cluster(ccode)	
	/*Model 14*/	logit coup coup_mean protests_near_mean protests_near_dev protests_far_mean protests_far_dev  dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, nolog cluster(ccode)	
	/*Model 15*/	logit coup coup_mean protests_violent_mean protests_violent_dev protests_peaceful_mean protests_peaceful_dev dem auth gdppc milreg cwongo mideast africa asia americas coupmonths coupmonths2 coupmonths3, nolog cluster(ccode)
